import logging

from defence360agent.contracts.config import ConfigFile

KEY = "MOD_SEC_BLOCK_BY_CUSTOM_RULE"

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    # adding brute-force rule to existing config
    # this is needed until DEFA-689 is done
    try:
        config_file = ConfigFile()
        config = config_file.config_to_dict(normalize=False)

        mod_sec_block_rules = config.setdefault(KEY, {})
        mod_sec_block_rules["33339"] = {
            "check_period": 120,
            "max_incidents": 10,
        }

        config_file.dict_to_config({KEY: mod_sec_block_rules})
    except Exception:
        logger.exception("Failed to create rule for 33339")


def rollback(migrator, database, fake=False, **kwargs):
    pass
