from peewee import BooleanField, CharField, Model


class FeatureManagementPerms(Model):
    class Meta:
        db_table = "feature_management_permissions"

    user = CharField(unique=True)
    proactive = BooleanField(default=True)


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(FeatureManagementPerms)


def rollback(migrator, database, fake=False, **kwargs):
    FeatureManagementPerms = migrator.orm["feature_management_permissions"]
    migrator.remove_model(FeatureManagementPerms)
