import peewee as pw


class Country(pw.Model):
    """
    Contains country code and name
    """

    id = pw.CharField(primary_key=True, null=False)
    code = pw.CharField(max_length=2, unique=True, null=False)
    name = pw.CharField(null=False)

    class Meta:
        db_table = "country"


class CaptchaStat(pw.Model):
    class Meta:
        db_table = "captcha_stat"
        primary_key = pw.CompositeKey(
            "event", "ip", "country", "domain", "timestamp"
        )

    event = pw.TextField(null=False)
    ip = pw.TextField(null=False)
    country = pw.ForeignKeyField(Country, null=True)
    domain = pw.TextField(null=True)
    timestamp = pw.IntegerField(null=False)

    count = pw.IntegerField(null=False)


def migrate(migrator, database, fake=False, **kwargs):
    migrator.create_model(CaptchaStat)


def rollback(migrator, database, fake=False, **kwargs):
    cs = migrator.orm["captcha_stat"]
    migrator.remove_model(cs)
