import logging

import peewee as pw


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    class DisabledRule(pw.Model):
        class Meta:
            db_table = "disabled_rules"
            indexes = ((("plugin", "rule_id"), True),)

        id = pw.PrimaryKeyField()
        plugin = pw.CharField(null=False)
        rule_id = pw.CharField(null=False)
        name = pw.TextField(null=False)

    class DisabledRuleDomain(pw.Model):
        disabled_rule_id_id = pw.ForeignKeyField(
            DisabledRule, backref="domains", on_delete="CASCADE"
        )
        domain = pw.CharField(null=False)

        class Meta:
            db_table = "disabled_rules_domains"
            primary_key = pw.CompositeKey("disabled_rule_id_id", "domain")

    migrator.create_model(DisabledRule)
    migrator.create_model(DisabledRuleDomain)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    migrator.remove_model(migrator.orm["disabled_rules_domains"])
    migrator.remove_model(migrator.orm["disabled_rules"])
