import os

import yaml

from defence360agent.contracts.config import LocalConfig


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    local_config = LocalConfig()
    if not os.path.exists(local_config.path):
        return
    with open(local_config.path) as f:
        conf = yaml.safe_load(f)

    malware_settings = conf.setdefault("MALWARE_SCANNING", {})

    value = malware_settings.pop("enable_scan_uploaded_files", True)

    malware_settings["enable_scan_pure_ftpd"] = value
    malware_settings["enable_scan_modsec"] = value

    local_config.dict_to_config(conf, validate=False)


def rollback(migrator, database, fake=False, **kwargs):
    pass
