import logging
import os
from pathlib import Path

from defence360agent.utils import os_version, OsReleaseInfo

logger = logging.getLogger(__name__)

TEST_REPO_PATH = Path("/etc/yum.repos.d/imunify360-testing.repo")

CHECKSITE = "https://repo.imunify360.cloudlinux.com/defense360"
RPM_KEY = "{}/RPM-GPG-KEY-CloudLinux".format(CHECKSITE)

# disabled by default
TEMPLATE_REPO = r"""
[imunify360-testing]
name=EL-{version} - Imunify360
baseurl={CHECKSITE}/el/{version}/updates-testing/x86_64/
username=defense360
password=nraW!F@\$x4Xd6HHQ
enabled=0
gpgcheck=1
gpgkey={RPM_KEY}
"""


def install_repo(version):
    if version in (6, 7):
        if not TEST_REPO_PATH.exists():
            TEST_REPO_PATH.write_text(
                TEMPLATE_REPO.format(
                    version=version, CHECKSITE=CHECKSITE, RPM_KEY=RPM_KEY
                )
            )
    else:
        logger.info("Version {} is not supported".format(version))


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    try:
        if OsReleaseInfo.id_like() & OsReleaseInfo.RHEL_FEDORA_CENTOS:
            version = None
            full_version = os_version()
            if full_version.startswith("6"):
                version = 6
            elif full_version.startswith("7"):
                version = 7

            install_repo(version)
    except Exception as e:
        logger.warning("Unable to add imunify360-testing repo: %s", e)


def rollback(migrator, database, fake=False, **kwargs):
    if fake:
        return

    try:
        os.remove(TEST_REPO_PATH)
    except Exception as e:
        logger.warning(str(e))
