# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2024 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# https://cloudlinux.com/docs/LICENCE.TXT
#
import logging
import pathlib

from clconfigure import run, task


@task("Unloading lve module")
def unload_lve_module():
    """
    Restart services that still use lve device and unload lve module then
    """
    # Check if lve device is held by any process
    res = run(['lsof', '/dev/lve'])
    res_stdout_lines = res.stdout.split() if res.stdout is not None else []

    services = [
        service for service in ['mysqld', 'mariadb', 'httpd']
        if any(line.startswith(service) for line in res_stdout_lines)
    ]

    if services:
        run(['systemctl', 'restart', *services])

    res = run(['modprobe', '-rf', 'kmodlve'])
    if pathlib.Path('/sys/module/kmodlve').exists():
        logging.warning('Failed to unload the lve module. Please reboot the server.')
