import asyncio


class LoggingProtocol(asyncio.Protocol):
    def __init__(self, logger, network_logger, real_protocol):
        self._logger = logger
        self._network_logger = network_logger
        self._real_protocol = real_protocol

    def connection_made(self, transport):
        self._network_logger.debug("Connection made.")
        self._handle(lambda: self._real_protocol.connection_made(transport))

    def connection_lost(self, exc):
        self._network_logger.debug("Connection lost.")
        self._handle(lambda: self._real_protocol.connection_lost(exc))

    def datagram_received(self, data, addr):
        self._network_logger.debug("datagram_received: {!r}".format(data))
        self._handle(lambda: self._real_protocol.datagram_received(data, addr))

    def data_received(self, data):
        self._network_logger.debug("data_received: {!r}".format(data))
        self._handle(lambda: self._real_protocol.data_received(data))

    def _handle(self, impl):
        try:
            impl()
        except Exception as e:
            self._logger.exception(str(e))
