import logging

logger = logging.getLogger(__name__)


class GlobalScope(dict):
    def __getattr__(self, item):
        try:
            return self[item]
        except KeyError as err:
            raise AttributeError(f"{item} is not in global scope") from err

    def __setattr__(self, key, value):
        if key in self:
            logger.warning("Name %s is already in global scope", key)
        else:
            self[key] = value


g = GlobalScope()
