import functools


@functools.lru_cache(maxsize=1)
def is_ssse3_supported():
    with open("/proc/cpuinfo") as f:
        return "ssse3" in f.read()
