# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from sqlalchemy import Column, Integer, String, Float, Index, BigInteger

from lvestats.orm.base import Base
from lvestats.orm.const import LVE_STATS_2_TABLENAME_PREFIX, SERVER_ID_LENGTH


class history_gov(Base):
    __tablename__ = LVE_STATS_2_TABLENAME_PREFIX + 'history_gov'
    ts = Column('ts', Integer, primary_key=True, autoincrement=False)
    uid = Column('uid', BigInteger, primary_key=True, autoincrement=False)
    sum_cpu = Column('sum_cpu', Float)
    sum_write = Column('sum_write', Float)
    sum_read = Column('sum_read', Float)
    limit_cpu_on_period_end = Column('limit_cpu_on_period_end', Integer)
    limit_read_on_period_end = Column('limit_read_on_period_end', Integer)
    limit_write_on_period_end = Column('limit_write_on_period_end', Integer)
    cause_of_restrict = Column('cause_of_restrict', Integer)
    server_id = Column('server_id', String(SERVER_ID_LENGTH), primary_key=True,
                       autoincrement=False)


# new index name for prevent migration conflict
Index(f'ix_{history_gov.__tablename__}_ts_2', history_gov.ts)
