from logging import getLogger
from typing import Any, List

import defence360agent.subsys.panels.hosting_panel as hp
from defence360agent.feature_management.constants import (
    AV,
    AV_REPORT,
    FULL,
    NA,
)
from defence360agent.feature_management.rpc.endpoints.utils import (
    builtin_feature_management_only,
)
from defence360agent.feature_management.utils import (
    update_default,
    update_users,
)
from defence360agent.rpc_tools.lookup import RootEndpoints, bind

logger = getLogger(__name__)


@builtin_feature_management_only
class FeatureManagementUpdateEndpoints(RootEndpoints):
    @staticmethod
    async def _update(feature: str, users: List[str], value: Any):
        if not users:
            return {
                "items": "succeed"
                if await update_default(feature, value)
                else "failed"
            }
        return {
            "items": await update_users(
                feature, users, value, await hp.HostingPanel().get_users()
            )
        }

    def _adapt_value(self, feature, value):
        if value:
            return FULL
        if feature == AV and not value:
            return AV_REPORT
        return NA

    @bind("feature-management", "enable")
    async def feature_management_enable(self, feature: str, users=None):
        """Enable specified feature"""
        return await self._update(
            feature, users, self._adapt_value(feature, True)
        )

    @bind("feature-management", "disable")
    async def feature_management_disable(self, feature: str, users=None):
        """Disable specified feature"""
        return await self._update(
            feature, users, self._adapt_value(feature, False)
        )
