from defence360agent.contracts.hook_events import HookEvent
from defence360agent.contracts.plugins import (
    MessageSink,
    MessageSource,
    expect,
)
from defence360agent.hooks.execute import execute_hooks

EVENTS = (
    HookEvent.AgentStarted,
    HookEvent.AgentMisconfig,
    HookEvent.LicenseExpired,
    HookEvent.LicenseExpiring,
    HookEvent.LicenseRenewed,
)


class EventHookExecutor(MessageSink, MessageSource):
    PROCESSING_ORDER = MessageSink.ProcessingOrder.EVENT_HOOK

    async def create_sink(self, loop):
        self._loop = loop

    async def create_source(self, loop, sink):
        self._loop = loop
        self._sink = sink

    @expect(*EVENTS)
    async def receive_event(self, event):
        self._loop.create_task(execute_hooks(event))
