from time import time

from peewee import CharField, IntegerField, BooleanField

from defence360agent.model import instance, Model
from defence360agent.model.simplification import FilenameField


class EventHook(Model):
    """Imunify Hooks v1.0 configuration.

    .. deprecated:: 4.10 A new notification system was implemented in DEF-11680
    """

    class Meta:
        database = instance.db
        db_table = "event_hook"

    #: The path to the hook script.
    path = FilenameField(null=False)
    #: The event for which it should trigger.
    event = CharField(null=False)
    #: Timestamp when the hook was added.
    created = IntegerField(null=False, default=lambda: int(time()))
    #: Native hooks can be imported and executed as Python directly, without
    #: creating a separate process.
    native = BooleanField(default=False)

    @classmethod
    def list_events(cls, event):
        q = cls.select()
        if event != "all":
            q = q.where(cls.event == event)
        return list(q.dicts())

    @classmethod
    def add_hook(cls, event, path, native=False):
        q = cls.select().where((cls.event == event) & (cls.path == path))
        if q.exists():
            return None
        hook = cls.create(event=event, path=path, native=native)
        return hook.as_dict()

    @classmethod
    def delete_hook(cls, event, path):
        q = cls.select().where((cls.event == event) & (cls.path == path))
        if not q.exists():
            return None
        hook = q.get()
        data = hook.as_dict()
        hook.delete_instance()
        return data

    def as_dict(self):
        return {
            "path": self.path,
            "event": self.event,
            "created": self.created,
            "native": self.native,
        }
