from typing import Union, Optional


class CronJob(object):
    __slots__ = "minute", "hour", "cmd"

    def __init__(
        self,
        *,
        minute: Union[int, str, None],
        hour: Union[int, str, None],
        cmd: Optional[str],
    ):
        self.minute = minute
        self.hour = hour
        self.cmd = cmd

    def __str__(self):
        return (
            "# DO NOT EDIT. AUTOMATICALLY GENERATED BY IMUNIFY360."
            f"\n{self.minute} {self.hour} * * * root {self.cmd}\n"
        )

    @classmethod
    def from_str(cls, data):
        minute = hour = cmd = None
        lines = [x for x in data.splitlines() if x[0] != "#"]
        if lines:
            line_members = lines[0].split(" ")
            minute = line_members[0]
            hour = line_members[1]
            cmd = " ".join(line_members[6:])
        return CronJob(minute=minute, hour=hour, cmd=cmd)
