# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#
import os
import jinja2

# Subject line prefix in template file
SUBJECT_LINE_PREFIX = 'Subject:'


# TODO: looks like this class is used only in lve-stats
# and we should move it there
class ClEmail:
    """
    class for generation email messages
    """
    def __init__(self):
        pass

    @staticmethod
    def generate_mail_jinja2(template_path, templ_data, subject=None):
        """
        Generates email message using jinja2 template engine
        :param template_path: path to jinja2 template
        :param templ_data: Data to fill template using jinja2
        :param subject: Email subject to use if it not found in template
        :return: Cortege (email_subject, email_body)
        """
        # load and render template
        templ_loader = jinja2.FileSystemLoader(os.path.dirname(template_path))
        templ_envir = jinja2.Environment(loader=templ_loader)
        message_lines = templ_envir.get_template(
            os.path.basename(template_path)
        ).render(
            templ_data
        ).split('\n')

        # Search subject string in template content
        if len(message_lines) > 2 and message_lines[0].startswith(SUBJECT_LINE_PREFIX) and message_lines[1] == '':
            subject = message_lines[0].replace(SUBJECT_LINE_PREFIX, '').strip()
            # Remove Subject line and separator (empty line) from message body
            message_lines.pop(1)
            message_lines.pop(0)

        return subject, '\n'.join(message_lines)
