# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#

# source code
# http://stackoverflow.com/questions/132058/showing-the-stack-trace-from-a-running-python-application
import code
import traceback
import signal


def debug(sig, frame):
    """
    Interrupt running process, and provide a python prompt for
    interactive debugging.
    """
    d = {'_frame': frame}  # Allow access to frame object

    d.update(frame.f_globals) # Unless shadowed by global
    d.update(frame.f_locals)

    i = code.InteractiveConsole(d)
    message = "Signal recieved : entering python shell.\nTraceback:\n"
    message += ''.join(traceback.format_stack(frame))
    i.interact(message)


def listen():
    signal.signal(signal.SIGUSR1, debug) # Register handler
