
package Mail::SpamAssassin::CompiledRegexps::body_0;

use strict;

use XSLoader ();

BEGIN {
our $VERSION = '1.0';
our @ISA = qw(XSLoader);
our @EXPORT_OK = qw();

our $HAS_RULES = {
    q#ACT_NOW_CAPS,[l=1]# => q#(?aa)\bA(?i:ct) N(?i:ow)\b#,
  q#BAD_CREDIT,[l=1]# => q#(?aa)(?i)\b(?:(?:bad|poor|eliminate|repair|(?:re)?establish|damag).{0,10} (?:credit|debt)|no credit (?:check|histor|need))#,
  q#BANG_GUAR,[l=1]# => q#(?aa)(?i)\bguaranteed?\!#,
  q#BANG_OPRAH,[l=1]# => q#(?aa)(?i)\boprah!#,
  q#BANKING_LAWS,[l=0]# => q#(?aa)(?i)banking laws#,
  q#BILLION_DOLLARS,[l=1]# => q#(?aa)[BM]ILLION DOLLAR#,
  q#BILL_1618,[l=1]# => q#(?aa)(?i)\bUnder Bill\s?s?.1618(?: Title III)? passed by the 105th U\.S\. Congress\b#,
  q#BODY_ENHANCEMENT,[l=1]# => q#(?aa)(?i)\b(?:enlarge|increase|grow|lengthen|larger\b|bigger\b|longer\b|thicker\b|\binches\b).{0,50}\b(?:penis|male organ|pee[ -]?pee|dick|sc?hlong|wh?anger|breast(?!\s+cancer))#,
  q#BODY_ENHANCEMENT2,[l=1]# => q#(?aa)(?i)\b(?:penis|male organ|pee[ -]?pee|dick|sc?hlong|wh?anger|breast(?!\s+cancer)).{0,50}\b(?:enlarge|increase|grow|lengthen|larger\b|bigger\b|longer\b|thicker\b|\binches\b|size)#,
  q#CUM_SHOT,[l=1]# => q#(?aa)(?i)\bcum[ -]?shots?\b#,
  q#CURR_PRICE,[l=1]# => q#(?aa)\bCurrent Price:#,
  q#DEAR_BENEFICIARY,[l=1]# => q#(?aa)(?i)\b(?:De[ae]r\s|At+(?:ention|n):?\s?)(?:\S+\s)?Ben[ei]ficiary\b#,
  q#DEAR_SOMETHING,[l=1]# => q#(?aa)(?i)\bDear (?:IT\W|Internet|candidate|sirs?|madam|investor|travell?er|car shopper|web)\b#,
  q#DEAR_WINNER,[l=1]# => q#(?aa)(?i)\bdear.{1,20}winner#,
  q#DIET_1,[l=1]# => q#(?aa)(?i)\b(?:(?:without|no) (?:exercis(?:e(?! price)|ing)|dieting)|weight.?loss|(?:extra|lose|lost|losing).{0,10}(?:pounds|weight|inches|lbs)|burn.{1,10}fat)\b#,
  q#DRUGS_SMEAR1,[l=1]# => q#(?aa)(?i)(?:Viagra|Valium|Xanax|Soma|Cialis){2}#,
  q#DRUG_ED_CAPS,[l=1]# => q#(?aa)\b(?:CIALIS|LEVITRA|VIAGRA)#,
  q#DRUG_ED_GENERIC,[l=1]# => q#(?aa)\bGeneric Viagra\b#,
  q#DRUG_ED_ONLINE,[l=1]# => q#(?aa)(?i)\bviagra .{0,25}(?:express|online|overnight)#,
  q#DRUG_ED_SILD,[l=1]# => q#(?aa)(?i)\bsildenafil\b#,
  q#DX_TEXT_03,[l=1]# => q#(?aa)\b[A-Z]{3} Media (?:Group|Relations)\b#,
  q#EMRCP,[l=1]# => q#(?aa)(?i)\bExcess (?:Maximum )?Return Capital (?:Profits?|Funds?)\b#,
  q#EM_ROLEX,[l=1]# => q#(?aa)(?i)[^\s\w.]rolex#,
  q#EXCUSE_24,[l=1]# => q#(?aa)(?i)you(?:'ve|'re| have| are)? receiv(?:e|ed|ing) this (?:advertisement|offer|special|recurring|paid).{0,16}\b(?:by either|because)#,
  q#EXCUSE_4,[l=1]# => q#(?aa)(?i)To Be Removed,? Please#,
  q#EXCUSE_REMOVE,[l=1]# => q#(?aa)(?i)to be removed from.{0,20}(?:mailings|offers)#,
  q#FIN_FREE,[l=1]# => q#(?aa)(?i)\bfinancial(?:ly)? (?:free|independen)#,
  q#FORWARD_LOOKING,[l=1]# => q#(?aa)(?i)\bcontains forward-looking statements\b#,
  q#FREE_PORN,[l=1]# => q#(?aa)(?i)\bfree (?:porn|xxx|adult)#,
  q#FREE_QUOTE_INSTANT,[l=1]# => q#(?aa)(?i)free.{0,12}(?:(?:instant|express|online|no.?obligation).{0,4})+.{0,32}\bquote#,
  q#GTUBE,[l=1]# => q#(?aa)XJS\*C4JDBQADN1\.NSBN3\*2IDNEN\*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL\*C\.34X#,
  q#GUARANTEED_100_PERCENT,[l=0]# => q#(?aa)(?i)100% GUARANTEED#,
  q#IMPOTENCE,[l=1]# => q#(?aa)(?i)\b(?:impotence (?:problem|cure|solution)|Premature Ejaculation|erectile dysfunction)#,
  q#INVESTMENT_ADVICE,[l=1]# => q#(?aa)(?i)\binvestment advice#,
  q#JOIN_MILLIONS,[l=1]# => q#(?aa)(?i)\bjoin (?:millions|thousands)\b#,
  q#LEADING_MANUFACTURER,[l=0]# => q#(?aa)(?i)(?:we (?:are|have been)|as) (?:a|the) leading (?:manufacturer|innovator) (?:in|of)#,
  q#LIVE_PORN,[l=1]# => q#(?aa)(?i)\blive .{0,9}(?:fuck(?:ing)?|sex|naked|girls?|virgins?|teens?|porno?)\b#,
  q#LONG_TERM_PRICE,[l=1]# => q#(?aa)(?i)long\W+term\W+(?:target|projected)(?:\W+price)?#,
  q#LOOPHOLE_1,[l=1]# => q#(?aa)(?i)loop-?hole in the banking#,
  q#LOW_PRICE,[l=1]# => q#(?aa)(?i)\blow.{0,4} (?-i:P)rice#,
  q#MALE_ENHANCE,[l=0]# => q#(?aa)(?i)male enhancement#,
  q#MARKETING_PARTNERS,[l=1]# => q#(?aa)(?i)\b(?:marketing|network) partner|\bpartner (?:web)?site#,
  q#MILLION_HUNDRED,[l=1]# => q#(?aa)(?i)Million\s+\S+\s+Hundred#,
  q#MILLION_USD,[l=1]# => q#(?aa)(?i)Million\b.{0,40}\b(?:United States? Dollars?|USD)#,
  q#MONEY_BACK,[l=0]# => q#(?aa)(?i)money back guarantee#,
  q#MORE_SEX,[l=1]# => q#(?aa)(?i)increased?.{0,9}(?:sex|stamina)#,
  q#NA_DOLLARS,[l=1]# => q#(?aa)(?i)\b(?:\d{1,3})?Million\b.{0,40}\b(?:Canadian Dollar?s?|US\$|U\.? ?S\.? Dollar)#,
  q#NOT_ADVISOR,[l=0]# => q#(?aa)(?i)not a registered investment advisor#,
  q#NOT_SPAM,[l=1]# => q#(?aa)(?i)\b(?:(?:this (?:e?-?mail|message)|we) (?:is not|are not|cannot be considered) Spam|ESTE CORREO NO PUEDE SER CONSIDERADO (?:INTRUSIVO|spam)|Diese Nachricht ist KEIN SPAM)#,
  q#NO_MEDICAL,[l=1]# => q#(?aa)(?i)\bno medical exam#,
  q#NO_PRESCRIPTION,[l=1]# => q#(?aa)(?i)N[o0].{1,10}P(?:er|re)scr[i1]pt[i1][o0]n.{1,10}(?:n[e3][e3]d[e3]d|requ[1i]re|n[e3]c[e3]ssary)#,
  q#ONE_TIME,[l=1]# => q#(?aa)(?i)\bone\W+time (?:charge|investment|offer|promotion)#,
  q#ONLINE_PHARMACY,[l=1]# => q#(?aa)(?i)\bonline pharmacy|\b(?:drugs|medications) online#,
  q#PREST_NON_ACCREDITED,[l=1]# => q#(?aa)(?i)prestigi?ous\b.{0,20}\bnon-accredited\b.{0,20}\buniversities#,
  q#PRICES_ARE_AFFORDABLE,[l=1]# => q#(?aa)(?i)\baffordable .{0,10}prices\b#,
  q#REFINANCE_NOW,[l=1]# => q#(?aa)(?i)time to refinance|refinanc\w{1,3}\b.{0,16}\bnow\b#,
  q#REFINANCE_YOUR_HOME,[l=1]# => q#(?aa)(?i)\brefinance your(?: current)? (?:home|house)\b#,
  q#REMOVE_BEFORE_LINK,[l=1]# => q#(?aa)(?i)(?:no thanks|not interested|unsubscribe here).{0,5}http://#,
  q#REPLICA_WATCH,[l=1]# => q#(?aa)(?i)\breplica.{1,20}rolex#,
  q#SCC_CANSPAM_2,[l=1]# => q#(?aa)you may unsubscribe by clicking here or by writing to#,
  q#SHORT_TERM_PRICE,[l=1]# => q#(?aa)(?i)short\W+term\W+(?:target|projected)(?:\W+price)?#,
  q#STOCK_ALERT,[l=1]# => q#(?aa)(?i)\bstock alert#,
  q#STRONG_BUY,[l=0]# => q#(?aa)(?i)strong buy#,
  q#TVD_ACT_193,[l=1]# => q#(?aa)(?i)\bact of (?:193|nineteen thirty)#,
  q#TVD_APPROVED,[l=1]# => q#(?aa)(?i)you.{1,2}re .{0,20}approved#,
  q#TVD_INCREASE_SIZE,[l=1]# => q#(?aa)(?i)\bsize of .{1,20}(?:penis|dick|manhood)#,
  q#TVD_LINK_SAVE,[l=1]# => q#(?aa)(?i)\blink to save\b#,
  q#TVD_PH_1,[l=1]# => q#(?aa)(?i)Dear valued .{1,40}(?:member|customer)#,
  q#TVD_PH_REC,[l=1]# => q#(?aa)(?i)\byour .{0,40}account .{0,40}record#,
  q#TVD_PH_SEC,[l=1]# => q#(?aa)(?i)\byour .{0,40}account .{0,40}security#,
  q#TVD_QUAL_MEDS,[l=1]# => q#(?aa)(?i)\bquality med(?:ication)?s\b#,
  q#TVD_SECTION,[l=1]# => q#(?aa)(?i)\bSection (?:27A|21B)#,
  q#TVD_VISIT_PHARMA,[l=1]# => q#(?aa)(?i)Online Ph.rmacy#,
  q#UNCLAIMED_MONEY,[l=1]# => q#(?aa)(?i)\bunclaimed\s(?:assets?|accounts?|mon(?:ey|ies)|balance|funds?|prizes?|rewards?|payments?|deposits?)\b#,
  q#VIA_GAP_GRA,[l=1]# => q#(?aa)(?i)\bvia.gra\b#,
  q#__ACCESS_RESTORE,[l=1]# => q#(?aa)(?i)\bto (?:(?:restore|regain) access|(?:remove|uplift) (?:the|this) suspens|continue using your (?:account|online|mailbox)|zugreifen wiederhergestellt)#,
  q#__ACCESS_REVOKE,[l=1]# => q#(?aa)(?i)(?:(?:temporary|permanent) (?:de-?activation|removal) of your (?:\w{1,30} )?(?:access|account)|Ihre Kreditkarte wird gesperrt)#,
  q#__ACCOUNT_ERROR,[l=1]# => q#(?aa)(?i)\b(?:your account (?:is|appears to be) (?:incorrect|missing|in error|invalid))\b#,
  q#__ACCOUNT_SECURE,[l=1]# => q#(?aa)(?i)\b(?:make your (?:"?[^\@\s]+\@\S+"? |e-?mail )?account more secure|Ihre Kreditkarte weist einige Sicherheitsprobleme)\b#,
  q#__ACCOUNT_UPGRADE,[l=1]# => q#(?aa)(?i)\b(?:upgrade (?:of )your (?:account|access)|your (?:access|account) is[\w\s]{0,40}being upgraded|Weiter zur Aktualisierung)\b#,
  q#__ACH_CANCELLED_02,[l=1]# => q#(?aa)(?i)(?:rejected|cancel+ed|declined|your)[-_ ](?:(?-i:ACH)|direct[-_ ]deposit)[-_ ](?:payment|transfer|transaction|declin(?:ed|ing))#,
  q#__ACH_CANCELLED_03,[l=1]# => q#(?aa)(?i)\bwire[-_ ]?(?:payment|transfer|transaction)[-_ ](?:(?:was|is)[-_ ])?(?:rejected|cancel+ed|declined|disabled|not[-_ ]accepted|(?:technical )?error)#,
  q#__ACH_CANCELLED_04,[l=1]# => q#(?aa)(?i)\bregarding[-_ ]your[-_ ]direct[-_ ]deposit[-_ ]via[-_ ](?-i:ACH)#,
  q#__ADMAIL,[l=1]# => q#(?aa)(?i)(?:\b|_)ad-?(?:mail|message)s?(?:\b|_)#,
  q#__ADMITS_SPAM,[l=1]# => q#(?aa)(?i)\bth(?:e[- ]+above|is)(?:\?+s|[- ]+is)[- ]+(?:intended[- ]+as[- ]+)?an?[- ]+(?:e-?mail[- ]+)?[a@]dvert[i1l]sement\b#,
  q#__ADULTDATINGCOMPANY_BODY,[l=1]# => q#(?aa)(?i)\bAdultDatingCompany\b#,
  q#__AFF_LOTTERY,[l=0]# => q#(?aa)(?i)(?:lottery|winner)#,
  q#__AFR_UNION,[l=1]# => q#(?aa)(?i)\bafrican\sunion\b#,
  q#__AGREED_RATIO,[l=1]# => q#(?aa)(?i)\b(?:agreed|sharing)\s(?:ratios?|percent\w+)\b#,
  q#__AM_DYING,[l=1]# => q#(?aa)(?i)\b(?:am\s(?:\S+\s)?dying|terminally\sill|cancer|en\sphase\sterminale|(?:become|is|devenu|maladie)\sincurable|que\sje\smeurs)\b#,
  q#__AUTO_ACCIDENT,[l=0]# => q#(?aa)(?i)auto(?:mobile)? accident#,
  q#__BACK_SCRATCH,[l=1]# => q#(?aa)(?i)\bmutual+y?\s(?:benefi(?:t|cial)|interest)\b#,
  q#__BANK_DRAFT,[l=1]# => q#(?aa)(?i)\bbank\sdraft#,
  q#__BARRISTER,[l=1]# => q#(?aa)(?i)\b(?:barrister|solicitor at law|barr\.)#,
  q#__BENIN,[l=1]# => q#(?aa)(?i)\bb(?:e|=E9|[\xe9]|[\xc3][\xa9])nin\b#,
  q#__BONUS_LAST_DAY,[l=1]# => q#(?aa)(?i)\b(?:last|final) day of the (?:\$\d+ |\d+ dollars? )?bonus offer(?:ing)?\b#,
  q#__BOUNCE_NEVER_SEE,[l=1]# => q#(?aa)(?i)\bThis is an autoresponder. I'll never see your message\b#,
  q#__BOUNCE_NONWORKING,[l=1]# => q#(?aa)(?i)\bYou have reached a non.?working address.  Please check\b#,
  q#__BOUNCE_NO_RESEND,[l=1]# => q#(?aa)\bPlease do not resend your original message\.#,
  q#__BOUNCE_OOO_B1,[l=1]# => q#(?aa)\bI ?.m away until .{10,20} and am unable to read your message\b#,
  q#__BOUNCE_OOO_B2,[l=1]# => q#(?aa)\bI am currently out of the office\b#,
  q#__BOUNCE_OOO_CB1,[l=1]# => q#(?aa)(?i)\bout of (?:the )?office\b#,
  q#__BOUNCE_OOO_CB2,[l=1]# => q#(?aa)(?i)\bon (?:vacation|holiday)\b#,
  q#__BOUNCE_OOO_CB3,[l=1]# => q#(?aa)(?i)\bolen lomalla\b#,
  q#__BOUNCE_OOO_CB4,[l=1]# => q#(?aa)(?i)\breturn to (?:the )?office\b#,
  q#__BTC_OBFU_5,[l=0]# => q#(?aa)(?i)&[hash]x62;&[hash]x69;&[hash]x74;&[hash]x63;&[hash]x6F;&[hash]x69;&[hash]x6E;#,
  q#__BURKINA_FASO,[l=1]# => q#(?aa)(?i)\bburkina\s?faso\b#,
  q#__CAN_HELP,[l=1]# => q#(?aa)(?i)\bcan help\b#,
  q#__CASHPRZ,[l=1]# => q#(?aa)cash prize of#,
  q#__CHARITY,[l=1]# => q#(?aa)(?i)\b(?:charit(?:y|[ai]ble)|orphans?|homeless|orphelins|sans\sabri)\b#,
  q#__CLEAN_MAILBOX,[l=1]# => q#(?aa)(?i)\b(?:(?:e-?mail|mail\s?box|violation:|(?-i:CLICK)) (?:quota size|clean(?:-?up))|clean ?up click ?here|(?:please|automatically) reduce (?:your|the) e?-?mail ?box size|reduce (?:your |the )?(?:e?-?mail(?: ?box)? )?size automatically)\b#,
  q#__COMPENSATION,[l=1]# => q#(?aa)(?i)\b(?:compensat(?:e|ion)|recompensed?|ausgleich)\b#,
  q#__CONTACT_ATTY,[l=1]# => q#(?aa)(?i)\bcontact(?:er)?\s(?:my|(?:de\s)?mon)\s(?:barrister|attou?rney|lawyer|avocat|gestionnaire)\b#,
  q#__CONTACT_YOU,[l=1]# => q#(?aa)(?i)\b(?:contact(?:ing)\syou|vous\scontacter?)\b#,
  q#__COURIER,[l=1]# => q#(?aa)(?i)\bcourier\s(?:company|service)\b#,
  q#__DAY_I_EARNED,[l=1]# => q#(?aa)(?i)day,?\sI\s(?:earned|got|received|made|brought\sin)\s\$\s?\d{3}#,
  q#__DBLCLAIM,[l=1]# => q#(?aa)avoid double claiming#,
  q#__DEAL,[l=1]# => q#(?aa)(?i)\b(?:(?:business|financial|this|the|mutual|die(?:se)?r?|cette|profitable)\s(?:deal|transa[ck]tion|proposal|off[er]{2}|venture|suggestion|partnership)|your\spartnership)#,
  q#__DECEASED,[l=1]# => q#(?aa)(?i)\b(?:the|my|your|der|du|le|meu?)\s(?:deceased|late|verstorbenen|d(?:i|e|=E9|[\xe9]|[\xc3][\xa9])funto?|d(?:e|=E9|[\xe9]|[\xc3][\xa9])nt|falecido)\b#,
  q#__DESTROY_ME,[l=1]# => q#(?aa)(?i)\b(?:destroy|hunt|quemar)\sm[eyi]\b#,
  q#__DESTROY_YOU,[l=1]# => q#(?aa)(?i)\b(?:destroy\syou|deine Zukunft zerst\S{1,3}ren)#,
  q#__DIED_IN,[l=1]# => q#(?aa)(?i)\bdied\sin\b#,
  q#__DIPLOMATIC,[l=1]# => q#(?aa)(?i)\bdiplomatic\b#,
  q#__DLND_ATTACH,[l=1]# => q#(?aa)(?i)\bdownload\sthe\sattach(?:ed|ment)\b#,
  q#__DORMANT_ACCT,[l=1]# => q#(?aa)(?i)\b(?:(?:dormant|abandoned|left\s?over)\s(?:account|fund|transaction|sum|deposit)|fonds\sdorment)#,
  q#__DOS_BODY_FRI,[l=1]# => q#(?aa)(?i)\bfri(?:day)?\b#,
  q#__DOS_BODY_MON,[l=1]# => q#(?aa)(?i)\bmon(?:day)?\b#,
  q#__DOS_BODY_SAT,[l=1]# => q#(?aa)(?i)\bsat(?:day)?\b#,
  q#__DOS_BODY_STOCK,[l=1]# => q#(?aa)(?i)\bstock\b#,
  q#__DOS_BODY_SUN,[l=1]# => q#(?aa)(?i)\bsun(?:day)?\b#,
  q#__DOS_BODY_THU,[l=1]# => q#(?aa)(?i)\bthu(?:r(?:s(?:day)?)?)?\b#,
  q#__DOS_BODY_TICKER,[l=1]# => q#(?aa)\b[A-Z]{4}\.(?:OB|PK)\b#,
  q#__DOS_BODY_TUE,[l=1]# => q#(?aa)(?i)\btue(?:s(?:day)?)?\b#,
  q#__DOS_BODY_WED,[l=1]# => q#(?aa)(?i)\bwed(?:nesday)?\b#,
  q#__DOS_CORRESPOND_EMAIL,[l=1]# => q#(?aa)correspond with me using my email#,
  q#__DOS_DROP_ME_A_LINE,[l=1]# => q#(?aa)Drop me a line at#,
  q#__DOS_EMAIL_DIRECTLY,[l=1]# => q#(?aa)(?:Email m[a-z]?e|address) direc(?:tl|lt)y at#,
  q#__DOS_FIN_ADVANTAGE,[l=1]# => q#(?aa)(?i)\bfinancial advantage#,
  q#__DOS_I_AM_25,[l=1]# => q#(?aa)I a.?m 25#,
  q#__DOS_I_DRIVE_A,[l=1]# => q#(?aa)I drive a#,
  q#__DOS_LET_GO_JOB,[l=1]# => q#(?aa)I was (?:let go|fired|layed off|dismissed) from a job I h(?:el|a)d for (?:2\d years|\d{3} months)#,
  q#__DOS_LINK,[l=1]# => q#(?aa)\blink\b#,
  q#__DOS_MEET_EACH_OTHER,[l=1]# => q#(?aa)(?:meet each other|[Mm]ay ?be we can meet)#,
  q#__DOS_MY_OLD_JOB,[l=1]# => q#(?aa)my old job#,
  q#__DOS_PERSONAL_EMAIL,[l=1]# => q#(?aa)personal email at#,
  q#__DOS_STEADY_COURSE,[l=1]# => q#(?aa)(?i)\bsteady (?:and increasing )?course\b#,
  q#__DOS_STRONG_CF,[l=1]# => q#(?aa)(?i)\bstrong cash flow#,
  q#__DOS_TAKING_HOME,[l=1]# => q#(?aa)Taking home \d (?:digit level|figures) in \d{1,2} months#,
  q#__DOS_WRITE_ME_AT,[l=1]# => q#(?aa)[Ww].?r.?i.?t.?e me at#,
  q#__DRUGS_ANXIETY2,[l=1]# => q#(?aa)(?i)\bAlprazolam\b#,
  q#__DRUGS_ANXIETY8,[l=1]# => q#(?aa)(?i)\bklonopin\b#,
  q#__DRUGS_ANXIETY9,[l=1]# => q#(?aa)(?i)\brivotril\b#,
  q#__DRUGS_ANXIETY_VAL,[l=0]# => q#(?aa)(?i)valium#,
  q#__DRUGS_ANXIETY_XAN,[l=1]# => q#(?aa)(?i)xan[ae]x#,
  q#__DRUGS_DIET3,[l=1]# => q#(?aa)(?i)\bbontril\b#,
  q#__DRUGS_DIET4,[l=1]# => q#(?aa)(?i)\bphendimetrazine\b#,
  q#__DRUGS_DIET5,[l=1]# => q#(?aa)(?i)\bdiethylpropion\b#,
  q#__DRUGS_DIET_PHEN,[l=1]# => q#(?aa)(?i)\bphentermine\b#,
  q#__DRUGS_ERECTILE2,[l=1]# => q#(?aa)(?i)\bV(?:agira|igara|iaggra|iaegra)\b#,
  q#__DRUGS_ERECTILE4,[l=1]# => q#(?aa)(?i)\bC(?:alis|ilias|ilais)\b#,
  q#__DRUGS_ERECTILE5,[l=1]# => q#(?aa)(?i)\b_{0,3}s[_\W]?[i1!|l\xEC-\xEF][_\W]?l[_\W]?d[_\W]?[e3\xE8-\xEB][_\W]?n[_\W]?[a4\xE0-\xE6@][_\W]?f[_\W]?[i1!|l\xEC-\xEF][_\W]?l c[_\W]?[i1!|l\xEC-\xEF][_\W]?t[_\W]?r[_\W]?[a4\xE0-\xE6@][_\W]?t[_\W]?[e3\xE8-\xEB]_{0,3}(?:\b|\s)#,
  q#__DRUGS_ERECTILE_C,[l=1]# => q#(?aa)(?i)\bCialis(?!\xc3\xa9|\xe9)\b#,
  q#__DRUGS_ERECTILE_L,[l=1]# => q#(?aa)(?i)\bLevitra\b#,
  q#__DRUGS_ERECTILE_V,[l=1]# => q#(?aa)(?i)\bViagra\b#,
  q#__DRUGS_MUSCLE2,[l=1]# => q#(?aa)(?i)\b_{0,3}cycl[o0\xF2-\xF6]b[e3\xE8-\xEB]nz[a4\xE0-\xE6@]pr[i1!|l\xEC-\xEF]n[e3\xE8-\xEB]_{0,3}(?:\b|\s)#,
  q#__DRUGS_MUSCLE5,[l=1]# => q#(?aa)(?i)\bskelaxin\b#,
  q#__DRUGS_PAIN11,[l=1]# => q#(?aa)(?i)\bzebutal\b#,
  q#__DRUGS_PAIN12,[l=1]# => q#(?aa)(?i)\besgic plus\b#,
  q#__DRUGS_PAIN2,[l=1]# => q#(?aa)(?i)\b_{0,3}c[o0\xF2-\xF6]deine_{0,3}\b#,
  q#__DRUGS_PAIN_FIO,[l=0]# => q#(?aa)(?i)fioricet#,
  q#__DRUGS_PAIN_VICO,[l=0]# => q#(?aa)(?i)vicodin#,
  q#__DRUGS_PAIN_VIOXX,[l=0]# => q#(?aa)(?i)vioxx#,
  q#__EARLY_DEMISE,[l=1]# => q#(?aa)(?i)\buntimely\sdeath\b#,
  q#__FAILED_LOGINS,[l=1]# => q#(?aa)(?i)unsuc+es+ful log-?[io]n at+empts#,
  q#__FB_COST,[l=1]# => q#(?aa)(?i)\bcost\b#,
  q#__FB_S_STOCK,[l=1]# => q#(?aa)(?i)\bstock#,
  q#__FB_TOUR,[l=1]# => q#(?aa)(?i)\btour#,
  q#__FEES,[l=1]# => q#(?aa)(?i)\b(?:security|safe\w*|courier|registration|pay|paid|up-?front|processing|delivery|transfer|keeping)[\s\w]{0,15}\s(?:fee|charge)s?\b#,
  q#__FOR_SALE_LTP,[l=1]# => q#(?aa)(?i)00\.? (?:less 10%|LTP)#,
  q#__FOR_SALE_NET,[l=1]# => q#(?aa)(?i)00\.? NET#,
  q#__FOR_SALE_OBO,[l=1]# => q#(?aa)(?i)\bor best offer\b#,
  q#__FOR_SALE_PRC_100K,[l=1]# => q#(?aa)(?i)\bprice:? \$\d\d\d,\d\d\d#,
  q#__FOR_SALE_PRC_10K,[l=1]# => q#(?aa)(?i)\bprice:? \$\d\d,\d\d\d#,
  q#__FOR_SALE_PRC_1K,[l=1]# => q#(?aa)(?i)\bprice:? \$\d,?\d\d\d[.\s]#,
  q#__FOUND_YOU,[l=1]# => q#(?aa)(?i)\b(?:I|we)\sfound\syour?\b#,
  q#__FRAUD,[l=1]# => q#(?aa)(?i)\b(?:de)?fraud#,
  q#__FRAUD_AON,[l=1]# => q#(?aa)(?i)\b(?:confidential|private|alternate|alternative) (?:(?:e-? *)?mail)\b#,
  q#__FRAUD_AUM,[l=1]# => q#(?aa)(?i)\bthe desk of\b#,
  q#__FRAUD_AXF,[l=0]# => q#(?aa)(?i)magnanimity#,
  q#__FRAUD_BEP,[l=1]# => q#(?aa)(?i)\b(?:bank of nigeria|central bank of|trust bank|apex bank|amalgamated bank)\b#,
  q#__FRAUD_BGP,[l=1]# => q#(?aa)(?i)\battached to ticket number\b#,
  q#__FRAUD_CKF,[l=0]# => q#(?aa)(?i)computer ballot system#,
  q#__FRAUD_DPR,[l=1]# => q#(?aa)(?i)\b(?:(?:respond|reply) (?:urgently|immediately)|(?:urgent|immediate|earliest) (?:reply|response))\b#,
  q#__FRAUD_ETX,[l=1]# => q#(?aa)(?i)\byour\b[^.]{0,99}\b(?:contact (?:details|information)|private (?:e?[- ]?mail|telephone|tel|phone|fax))\b#,
  q#__FRAUD_EZY,[l=1]# => q#(?aa)(?i)\b(?:of|the) late president\b#,
  q#__FRAUD_FBI,[l=1]# => q#(?aa)(?i)\bdisburs#,
  q#__FRAUD_FCW,[l=0]# => q#(?aa)(?i)fiduciary agent#,
  q#__FRAUD_FVU,[l=0]# => q#(?aa)(?i)award notification#,
  q#__FRAUD_GBW,[l=1]# => q#(?aa)(?i)god gives .{1,10}second chance#,
  q#__FRAUD_IOU,[l=1]# => q#(?aa)(?i)\b(?:no risks?|risk-? *free|free of risks?|100% safe)\b#,
  q#__FRAUD_IOV,[l=1]# => q#(?aa)(?i)\b(?:no risks?|risky?[- ]{0,3}free|free of risks?|100% safe|v\S{1,3}llig Risikofrei ist)\b#,
  q#__FRAUD_IPK,[l=1]# => q#(?aa)(?i)\b(?:in|to|visit) your country\b#,
  q#__FRAUD_IRJ,[l=0]# => q#(?aa)(?i)(?:finance|holding|securit(?:ies|y)) (?:company|firm|storage house)#,
  q#__FRAUD_IRT,[l=1]# => q#(?aa)(?i)\b(?:compliments? of the|dear friend|dear sir|yours faithfully|season'?s greetings)\b#,
  q#__FRAUD_JBU,[l=1]# => q#(?aa)(?i)\bforeign account\b#,
  q#__FRAUD_JNB,[l=1]# => q#(?aa)(?i)\boperat(?:e|ing)\b[^.]{0,99}\b(?:for(?:ei|ie)gn|off-? ?shore|over-? ?seas?) (?:bank )?accounts?\b#,
  q#__FRAUD_JYG,[l=1]# => q#(?aa)(?i)\bgive\s+you .{0,15}(?:fund|money|total|sum|contact|percent)\b#,
  q#__FRAUD_KJV,[l=0]# => q#(?aa)(?i)(?:claim|concerning) (?:the|this) money#,
  q#__FRAUD_LTX,[l=1]# => q#(?aa)(?i)\bmilli?on (?:.{1,25} thousand\s*)?(?:(?:united states|u\.?s\.?) dollars|(?i:U\.?S\.?D?))\b#,
  q#__FRAUD_MCQ,[l=1]# => q#(?aa)(?i)\btransaction\b.{1,30}\b(?:magnitude|diplomatic|strict|absolute|secret|confiden(?:tial|ce)|guarantee)#,
  q#__FRAUD_MLY,[l=1]# => q#(?aa)(?i)\b(?:reply|respond)\b[^.]{0,50}\b(?:to|through)\b[^.]{0,50}\@\b#,
  q#__FRAUD_MQO,[l=0]# => q#(?aa)(?i)foreign (?:business partner|customer)#,
  q#__FRAUD_NEB,[l=0]# => q#(?aa)(?i)(?:government|bank) of nigeria#,
  q#__FRAUD_NRG,[l=0]# => q#(?aa)(?i)i am contacting you#,
  q#__FRAUD_PTS,[l=1]# => q#(?aa)(?i)\b(?:ass?ass?inat(?:ed|ion)|murder(?:e?d)?|kill(?:ed|ing)\b[^.]{0,99}\b(?:war veterans|rebels?))\b#,
  q#__FRAUD_PTX,[l=1]# => q#(?aa)(?i)\b(?:ass?ass?inat(?:ed|ion)|murder(?:e?d)?|poison(?:e?d)?|kill(?:ed|ing|ers)\b[^.]{0,99}\b(?:war veterans|rebels?)|les tueurs)\b#,
  q#__FRAUD_PVN,[l=0]# => q#(?aa)(?i)as the beneficiary#,
  q#__FRAUD_QFY,[l=1]# => q#(?aa)(?i)\bover-? *(?:invoiced?|cost(?:s|ing)?)\b#,
  q#__FRAUD_QXX,[l=1]# => q#(?aa)(?i)\b(?:my name is|i am) (?:mrs?|engr|barrister|dr|prince(?:ss)?)[. ]#,
  q#__FRAUD_RLX,[l=1]# => q#(?aa)(?i)lott(?:o|ery) (?:co,?ordinator|international)#,
  q#__FRAUD_SNT,[l=1]# => q#(?aa)(?i)\blocate(?: .{1,20})? extended relative#,
  q#__FRAUD_TCC,[l=0]# => q#(?aa)(?i)foreign (?:offshore )?(?:bank|account)#,
  q#__FRAUD_TDP,[l=1]# => q#(?aa)(?i)\b(?:business partner(?:s|ship)?|silent partner(?:s|ship)?)\b#,
  q#__FRAUD_THJ,[l=0]# => q#(?aa)(?i)modalit(?:y|ies)#,
  q#__FRAUD_ULK,[l=1]# => q#(?aa)(?i)\baffidavits?\b#,
  q#__FRAUD_UOQ,[l=0]# => q#(?aa)(?i)vital documents#,
  q#__FRAUD_UUY,[l=1]# => q#(?aa)(?i)\blegitimate business(?:es)?\b#,
  q#__FRAUD_WDR,[l=1]# => q#(?aa)(?i)\bprivate lawyer\b#,
  q#__FRAUD_WFC,[l=1]# => q#(?aa)(?i)\bsecur(?:e|ing) (?:the )?(?:funds?|monies)\b#,
  q#__FRAUD_WNY,[l=1]# => q#(?aa)(?i)\b(?:disburse?(?:ment)?|incurr?(?:ed)?|remunerr?at(?:ed?|ion)|remm?itt?(?:ed|ance|ing)?)\b#,
  q#__FRAUD_XJR,[l=0]# => q#(?aa)(?i)(?:who was a|as a|an? honest|you being a|to any) foreigner#,
  q#__FRAUD_XVW,[l=1]# => q#(?aa)(?i)\bhonest cooperation\b#,
  q#__FRAUD_XWW,[l=1]# => q#(?aa)(?i)\b(?:honest(?:ly)?\sco(?:-?operat(?:e|ion)|llaborat(?:e|ion))|ehrliche\szusammenarbeit|sichere [kc]o+p[eo]ration|col+aboration\swith\sme)\b#,
  q#__FRAUD_YJA,[l=0]# => q#(?aa)(?i)over-invoice#,
  q#__FRAUD_YPO,[l=0]# => q#(?aa)(?i)the total sum#,
  q#__FRAUD_YQV,[l=0]# => q#(?aa)(?i)nigerian? (?:national|government)#,
  q#__FRAUD_YWW,[l=1]# => q#(?aa)(?i)\bfurnish you with\b#,
  q#__FRAUD_ZFJ,[l=1]# => q#(?aa)(?i)\b(?:wife|son|brother|daughter) of the late\b#,
  q#__GAPPY_SALES_LEADS,[l=1]# => q#(?aa)(?i)\b(?:business|e?-?mail|your|marketing|advertising)\s(?!sales|leads|campaign)(?:s\s?a\s?l\s?e\s?s|l\s?e\s?a\s?d\s?s|c\s?a\s?m\s?p\s?a\s?i\s?g\s?n)\b#,
  q#__GHANA,[l=1]# => q#(?aa)(?i)\bghana\b#,
  q#__HAS_WON_01,[l=1]# => q#(?aa)(?i)\bque ha ganado\b#,
  q#__HK_LOTTO_2,[l=1]# => q#(?aa)(?i)\blot(?:eri[ej]|t(?:ery|o)) ?(?:(?:inter)?national|foundation|mercato|univers|euro ?million|e-?mail|euro-pw|bill ?gates|swiss|prestige|cristal|am.ricaine|coca.?cola|fiduciary|department)#,
  q#__HK_LOTTO_BALLOT,[l=1]# => q#(?aa)(?i)\b(?:promotional|on.?line|computer|internet|e-?mail|fran.aise) (?:ballot|draw|sweepstake)#,
  q#__HK_LOTTO_STAATS,[l=1]# => q#(?aa)(?i)\bstaatsloteri#,
  q#__HK_SCAM_N15,[l=1]# => q#(?aa)(?i)\b(?:account (?:overseas?|offshore)|(?:overseas?|offshore) account)\b#,
  q#__HK_SCAM_N16,[l=1]# => q#(?aa)(?i)\b(?:arrangement secret|secret arrangement)\b#,
  q#__HK_SCAM_N2,[l=1]# => q#(?aa)(?i)\bnext of kin\b#,
  q#__HK_SCAM_N3,[l=1]# => q#(?aa)(?i)\bdirect telephone numbers?\b#,
  q#__HK_SCAM_N8,[l=1]# => q#(?aa)(?i)\byour compensation\b#,
  q#__HK_SCAM_S1,[l=0]# => q#(?aa)(?i)pay you the sum of#,
  q#__HK_SCAM_S15,[l=0]# => q#(?aa)(?i)(?:discovered a dormant account|can you be my partner)#,
  q#__HK_SCAM_S25,[l=1]# => q#(?aa)(?i)\bbank (?:in|of) ghana#,
  q#__HUSH_HUSH,[l=1]# => q#(?aa)(?i)\b(?:confiden[tc]i[ae]l(?:\b|ity\b|it(?:=E9|[\xe9]|[\xc3][\xa9]))|private\b|secr[e\xe8](?:te?|cy)\b|sensitive\b|concealed\b|obscured?\b|discre(?:et|tion)\b|very\sdiscrete|top\ssecret|vertraulich(?:en)?\b|geheim\b|priv(?:e|=E9|[\xe9]|[\xc3][\xa9]))#,
  q#__INHERIT_PMT,[l=1]# => q#(?aa)(?i)\binheritance\spayment\s#,
  q#__INTL_BANK,[l=1]# => q#(?aa)(?i)\b(?:international\s(?:\w+\s)?bank|banque\sinternationale)\b#,
  q#__INVEST_COUNTRY,[l=1]# => q#(?aa)(?i)\binvest\sin\syour?\scountry\b#,
  q#__INVEST_MONEY,[l=1]# => q#(?aa)(?i)\binvest(?:ir)?\s(?:this|ces|d[ae]s|sur ce|de ces)\s(?:money|f[ou]nds?)\b#,
  q#__ISO_2022_JP_DELIM,[l=1]# => q#(?aa)\e\$B#,
  q#__IVORY_COAST,[l=1]# => q#(?aa)(?i)\b(?:Cote\s?D.Ivoire|Ivory\s?Coast|Costa\sde\sMarfil)\b#,
  q#__I_INHERIT,[l=1]# => q#(?aa)(?i)\b(?:I|eu)\s[a-z\s]{0,30}(?:inherited|herdei)\b#,
  q#__I_WILL_YOU,[l=1]# => q#(?aa)(?i)\bwill(?:ed)?\s(?:[a-z\s]{0,20}(?:fortune|money|\$[\d,]+[a-z]{0,9})\s)?to\syou\b#,
  q#__JAPANESE_UCE_BODY,[l=1]# => q#(?aa)(?:L\$>5Bz|EE;R%a!<%k)(?:8x|9-)9p#,
  q#__KAM_LOTTO2,[l=1]# => q#(?aa)(?is)(?:(?:ticket|serial|lucky) number|secret pin ?code|batch number|reference number|promotion date)#,
  q#__LARGE_PERCENT_AFTER,[l=1]# => q#(?aa)(?i)\d{3}% after#,
  q#__LOTSA_MONEY_05,[l=1]# => q#(?aa)(?i)(?:(?:sum|value|amount)\sof\s)<NUM_NOT_DATE_IP>[\d.,\sO]{7,20}[\dO\.][\)\]\(\s]{0,3}(?:pounds?|dollars?|euros?|bucks)\b#,
  q#__LOTTO_ADMITS_2,[l=1]# => q#(?aa)(?i)\b(?:free)?(?:lot(?:to|tery|erie)|sweepstakes)\s(?:(?:inter)?na[tz]ional|department|bureau|group|award|microsoft)#,
  q#__LOTTO_AGENT_02,[l=1]# => q#(?aa)(?i)\blot+ery[^\.]{1,40} ticket agent#,
  q#__LOTTO_DEPT,[l=1]# => q#(?aa)(?i)\b(?:claim(?:s|ing)?(?:\sprocessing)?|fiducia\w+|reimbursement|(?:international|foreign|win+ing)(?:\s(?:rem+it+ance|settlement|payment|award))+|payment|award|compensation|lot+ery)(?:\s\w+)?\s?(?:department|dept|unit|group|committee|bureau)#,
  q#__LOTTO_VERIFY,[l=1]# => q#(?aa)(?i)\bpromo\sverification#,
  q#__LOTTO_WIN_01,[l=1]# => q#(?aa)(?i)\bwin+ing\s(?:prize|number|notification|draw|check|cheque|details|information|payment)#,
  q#__LUCKY_WINNER,[l=1]# => q#(?aa)(?i)\b(?:lucky|gl.cklich(?:en)?|afortunados)\s(?:(?:ge)?win+ers?|ganador(?:es)?|individuals?)\b#,
  q#__LUCRATIVE,[l=1]# => q#(?aa)(?i)\b(?:lucrative|profitable|tr[\xe8]s\ssalutaire)\b#,
  q#__MAILBOX_FULL_SE,[l=1]# => q#(?aa)(?i)(?:\b=F6|[\xf6]|[\xc3][\xb6])verskridit gr(?:=E4|[\xe4]|[\xc3][\xa4])nsen f(?:=F6|[\xf6]|[\xc3][\xb6])r din postl(?:=E5|[\xe5]|[\xc3][\xa5])da\b#,
  q#__MAIL_ACCT_ACCESS1,[l=1]# => q#(?aa)(?i)\b(?:your (?:web ?|e-?)?mail (?:account|log-?in) (?:has )?been accessed|r(?:=F3|[\xf3])zne komputery zalogowaniu sie)\b#,
  q#__MAIL_ACCT_ACCESS2,[l=1]# => q#(?aa)(?i)\blo+se ac+es+ to your (?:web|e-?)?mail ?(?:account|log-?in|box|address)\b#,
  q#__MAKE_XTRA_DOLLAR,[l=1]# => q#(?aa)(?i)\bmake an extra dollar\b#,
  q#__MILLIONS,[l=1]# => q#(?aa)(?i)\bmillions\sof\s(?:dollar|euro|pound)#,
  q#__MONERO_CURNCY,[l=1]# => q#(?aa)Monero \(XMR\)#,
  q#__MY_FORTUNE,[l=1]# => q#(?aa)(?i)\b(?:my|his|her)\s(?:fortune|heritage)\b#,
  q#__NEXT_OF_KIN,[l=1]# => q#(?aa)(?i)\bnext[-\s]of[-\s]kin\b#,
  q#__NIGERIA,[l=1]# => q#(?aa)(?i)\bnigeria\b#,
  q#__NOT_DEAD_YET,[l=1]# => q#(?aa)(?i)\b(?:will\sinherit|que\sherede|your\sdeath|your?\sbeing\sdead)\b#,
  q#__NOT_SCAM,[l=1]# => q#(?aa)(?i)\b(?:not\sa\sscam|(?:not|never)\sscam\syou)\b#,
  q#__OBFU_UNSUB_UL,[l=1]# => q#(?aa)(?:click_here|remove_your|our_e?mail|this_list|to_unsubscribe|future_e?mail|our_list)#,
  q#__OUR_BEHALF,[l=1]# => q#(?aa)(?i)\b(?:on\s(?:my|our)\sbehalf|of\sbehalf\sof)\b#,
  q#__PASSIVE_INCOME,[l=1]# => q#(?aa)(?i)\bpassive income\b#,
  q#__PASSWORD_EXP_CLUMSY,[l=1]# => q#(?aa)(?i)\bpassword is due for expiration yesterday\b#,
  q#__PASSWORD_UPGRADE,[l=1]# => q#(?aa)(?i)\bpassword upgrade\b#,
  q#__PAY_YOU,[l=1]# => q#(?aa)\bpay\syou\b#,
  q#__PDS_EXPIRATION_NOTICE,[l=1]# => q#(?aa)(?i)\bexpiration (?:notice|alert|date)\b#,
  q#__PDS_OFFER_ONLY_AMERICA,[l=0]# => q#(?aa)(?i)This offer (?:is )?(?:only )?for (?:United States|USA)#,
  q#__PDS_SENT_TO_EMAIL_ADDR,[l=0]# => q#(?aa)(?i)This message was sent to Email Address\.#,
  q#__PDS_SEO2,[l=1]# => q#(?aa)(?i)(?:losing your|your website) (?:[a-z]+ )?(?:rank(?:ing)?|results)|rank well on [a-z]+\b#,
  q#__PERFECT_BINARY,[l=1]# => q#(?aa)(?i)\bperfect binary option\b#,
  q#__PILL_PRICE_01,[l=1]# => q#(?aa)(?i)(?=[\d .f])(?:free|[\d .]{3}(?:/|per|each)) ?(?=[ptc])(?:pill|tablet|cap(?:sule|let))s?\b#,
  q#__PILL_PRICE_02,[l=1]# => q#(?aa)(?i)(?=[ptc])(?:pill|tablet|cap(?:sule|let))s[-= :]{1,5}\$?[\d .]{3}#,
  q#__PLS_REVIEW,[l=1]# => q#(?aa)(?i)\b(?:please|kindly)\s(?:(?:re)?view|see)(?:\s\w+)?\sattach(?:ed|ment)\b#,
  q#__PUMPDUMP_01,[l=1]# => q#(?aa)(?i)\b(?:times|multiply|tripl(?:e|ing)|quadrupl(?:e|ing)|quintupl(?:e|ing)) (?:your|an) (?:princip(?:al|le)|investment)\b#,
  q#__PUMPDUMP_03,[l=1]# => q#(?aa)(?i)\bbuy (?:[^.!]{1,30} )?(?:(?:(?:mon|tues|wednes|thurs|fri)day|tomorrow) (?:first thing|open|morning)|(?:first thing|opens|before) (?:(?:mon|tues|wednes|thurs|fri)day|tomorrow))#,
  q#__PUMPDUMP_04,[l=1]# => q#(?aa)(?i)\bmake you (?:big bucks|hundreds|thousands)\b#,
  q#__PUMPDUMP_06,[l=1]# => q#(?aa)(?i)\brecommend(?:ed|s)? (?:a|this) (?:company|stock)\b#,
  q#__PUMPDUMP_07,[l=1]# => q#(?aa)(?i)\b(?:buy|grab it) for (?:around |about |less than )?\d+ cents\b#,
  q#__PUMPDUMP_08,[l=1]# => q#(?aa)(?i)\b(?:sto[ck]{2}|sotk) of the year#,
  q#__PUMPDUMP_09,[l=1]# => q#(?aa)(?i)\b(?:buy|get|snap up|grab) as many shares (?:of it )?as (?:you|I) can\b#,
  q#__PUMPDUMP_10,[l=1]# => q#(?aa)(?i)\btrading at (?:such )?a (?:bargain|cheap|low)\b#,
  q#__RANDOM_PICK,[l=1]# => q#(?aa)(?i)\b(?:random(?:ly)?\s(?:\w+\s)?(?:select(?:ion|ed)|pick(?:ed)?|computer)|(?:select|pick)ed\s(?:at\s)?random(?:ly)?|(?:esco(?:g|lh)idos|seleccion) (?:aleatoria(?:mente)?|al azar))\b#,
  q#__RECEIVE_BONUS,[l=1]# => q#(?aa)(?i)\byou(?:'ll)?(?: also| will)* (?:rec[ei]*ve|get|earn|collect|be (?:awarded|handed|remitted|given|paid|(?:greeted|welcomed|started) with)) (?:an? )?(?:gift|bonus|extra)(?: of|:)? \$[\d,]+#,
  q#__RELEASE_MESSAGES,[l=1]# => q#(?aa)(?i)\b(?:release messages|(?:retrieve|release|download) your(?: undelivered|unreceived|held|pending)? e?-?mails|(?:e?-?mails|messages).{1,20}download them now)\b#,
  q#__RUDE_HTML_1,[l=0]# => q#(?aa)(?i)Get a capable html e-mailer#,
  q#__RUDE_HTML_2,[l=1]# => q#(?aa)(?i)not support the display of HTML. Please view this message in a different#,
  q#__RUDE_HTML_3,[l=0]# => q#(?aa)(?i)This message contains an HTML formatted message but your email client does#,
  q#__RUDE_HTML_4,[l=1]# => q#(?aa)(?i)Your mailer do not support HTML messages. Switch to a better mailer#,
  q#__SCAM,[l=1]# => q#(?aa)(?i)\bscam(?:m?e[dr])?s?\b#,
  q#__SECURITY_DEPT,[l=1]# => q#(?aa)(?i)\bsecurity dep(?:artmen)?t\b#,
  q#__STAY_HOME,[l=1]# => q#(?aa)(?i)\b(?:going out of|leaving)(?: your)? (?:home|house|residence)\b#,
  q#__STOCK_TIP,[l=1]# => q#(?aa)(?i)\bsto[ck]{2}\s?tip\b#,
  q#__SUBSCRIPTION_INFO,[l=1]# => q#(?aa)(?i)\b(?:e?newsletters?|(?:un)?(?:subscrib|register)|you(?:r| are) subscri(?:b|ption)|opt(?:.|ing)?out\b|further info|you do ?n[o']t w(?:ish|ant)|remov\w{1,3}.{1,9}\blists?\b|to your white.?list)#,
  q#__SUM_OF_FUND,[l=1]# => q#(?aa)(?i)\b(?:sum|release|freigabe)\s(?:of|der)\s(?:amount|fund|investment|mittel)\b#,
  q#__SURVEY,[l=1]# => q#(?aa)(?i)\bsurvey\b#,
  q#__SUSPICION_LOGIN,[l=1]# => q#(?aa)(?i)\bsuspicion login\b#,
  q#__SYSADMIN,[l=1]# => q#(?aa)(?i)\b(?:help?[- ]?desk|(?:(?:web ?)?mail ?|sys(?:tem )?)admin(?:istrator)|local[- ]host|(?:support|upgrade|management|security|admin(?:istrat(?:or|ion))?) (?:team|center)|message from administrator|university mail server copyright|suporte t(?:=E9|[\xe9]|[\xc3][\xa9])cnico|administrador do sistema)\b#,
  q#__THEY_INHERIT,[l=1]# => q#(?aa)(?i)\b(?:inherit\sth(?:e|is)\smoney|herede\sest[ea]\sdinero)\b#,
  q#__THIS_AD,[l=1]# => q#(?aa)(?i)(?:\b|_)this[- _]+(?:ad(?:vert[i1l]sement)?|promo(?:tion)?)s?(?:\b|_)#,
  q#__TO_YOUR_ORG,[l=1]# => q#(?aa)(?i)\b(?:to|for) your organi[sz]ation\b#,
  q#__TRANSFORM_LIFE,[l=1]# => q#(?aa)(?i)\b(?:transform|change) your (?:daily )?life(?:style)?\b#,
  q#__TRAVEL_AGENT,[l=1]# => q#(?aa)(?i)\btravel\sagen(?:t|cy)\b#,
  q#__TRAVEL_BUSINESS,[l=1]# => q#(?aa)(?i)\bbusiness\stravel\b#,
  q#__TRAVEL_ITINERARY,[l=0]# => q#(?aa)(?i)(?:travel|ticketed|your|current) itinerary#,
  q#__TRAVEL_PROFILE,[l=1]# => q#(?aa)(?i)\btravel+er\sprofile\b#,
  q#__TRAVEL_RESERV,[l=1]# => q#(?aa)(?i)\b(?:reservation\s(?:confirmed|number)|travel\sreservations?)\b#,
  q#__TRTMT_DEFILED,[l=1]# => q#(?aa)(?i)\bdefiled\sall\s(?:forms\sof\s)?(?:medical\s)?treatments?\b#,
  q#__TRUNK_BOX,[l=1]# => q#(?aa)(?i)\b(?:(?:trunk|metallic|proof|security|consignment)\sbox(?:es)?|sealed\ssafe|une mallette m(?:e|=E9|[\xe9]|[\xc3][\xa9])tallique)\b#,
  q#__TRUSTED_CHECK,[l=1]# => q#(?aa)(?i)\b(?:cashier'?s?|certified)\sche(?:ck|que)#,
  q#__TVD_PH_BODY_01,[l=1]# => q#(?aa)(?i)\baccount .{0,20}placed? [io]n restricted status#,
  q#__TVD_PH_BODY_02,[l=1]# => q#(?aa)(?i)\brecords (?:[a-z_,-]+ )+?(?:feature|(?:a|re)ward)#,
  q#__TVD_PH_BODY_03,[l=1]# => q#(?aa)(?i)\byou(?:'ve| have) been (?:[a-z_,-]+ )+?payment#,
  q#__TVD_PH_BODY_04,[l=1]# => q#(?aa)(?i)\bfunds? (?!transfer from)(?!from)(?!in)(?!via)(?:[a-z_,-]+ )+?to your (?:[a-z_,-]+ )*?account#,
  q#__TVD_PH_BODY_05,[l=1]# => q#(?aa)(?i)\bthis is (?:[a-z_,-]+ )+?protect (?:[a-z_,-]+ )+?your#,
  q#__TVD_PH_BODY_06,[l=1]# => q#(?aa)(?i)Dear [a-z]+ bank (?:member|customer)#,
  q#__TVD_PH_BODY_07,[l=1]# => q#(?aa)(?i)\bguarantee the safety of your (?:[a-z_,-]+ )*?account#,
  q#__TVD_PH_BODY_08,[l=1]# => q#(?aa)(?i)\bmultiple password failures#,
  q#__TVD_PH_BODY_ACCOUNTS_POST,[l=1]# => q#(?aa)(?i)\b(?:(?:[dr]e-?)?activat[a-z]*|(?:re-?)?validate|secure|restore|confirm|update|suspend) (?!your)(?:[a-z_,-]+ )+?accounts?\b#,
  q#__TVD_PH_BODY_ACCOUNTS_PRE,[l=1]# => q#(?aa)(?i)\baccounts? (?:[a-z_,-]+ )+?(?:record[a-z]*|suspen[a-z]+|notif(?:y|ication)|updated|verifications?|credited)\b#,
  q#__UN,[l=1]# => q#(?aa)(?i)\bunited\snations?\b#,
  q#__UNSUB_GOOG_FORM,[l=1]# => q#(?aa)(?i)Unsub?sc?ribe\s<?https?://docs\.google\.com/forms/#,
  q#__URG_BIZ,[l=1]# => q#(?aa)(?i)urgent.{0,16}(?:assistance|business|buy|confidential|notice|proposal|reply|request|response)#,
  q#__VALIDATE_MBOX_SE,[l=1]# => q#(?aa)(?i)(?:\b=E5|[\xe5]|[\xc3][\xa5])terst(?:=E4|\xe4|[\xc3][\xa4])lla ditt konto\b#,
  q#__VBOUNCE_AMAVISD2,[l=1]# => q#(?aa)\bV I R U S\b#,
  q#__VBOUNCE_AOL,[l=1]# => q#(?aa)TRANSACTION FAILED - Unrepairable Virus Detected. #,
  q#__VBOUNCE_ATTACHMENT0,[l=1]# => q#(?aa)(?:Attachment.{0,40}was Deleted|the infected attachment)#,
  q#__VBOUNCE_ATT_QUAR,[l=1]# => q#(?aa)\bThe attachment was quarantined\b#,
  q#__VBOUNCE_AVREPORT0,[l=0]# => q#(?aa)(?i)(?:antivirus system report|the antivirus module has|illegal attachment|Unrepairable Virus Detected)#,
  q#__VBOUNCE_CLICKBANK,[l=1]# => q#(?aa)(?i)\bvirus scanner deleted your message\b#,
  q#__VBOUNCE_DUTCH,[l=1]# => q#(?aa)bevatte bijlage besmet welke besmet was met een virus#,
  q#__VBOUNCE_EXIM,[l=1]# => q#(?aa)a potentially executable attachment #,
  q#__VBOUNCE_GUIN,[l=1]# => q#(?aa)message contains file attachments that are not permitted#,
  q#__VBOUNCE_MAILMARSHAL,[l=1]# => q#(?aa)Mail.?Marshal Rule: Inbound Messages : Block Dangerous Attachments#,
  q#__VBOUNCE_MAILSWEEP,[l=1]# => q#(?aa)MAILsweeper has found that a \S+ \S+ \S+ \S+ one or more virus#,
  q#__VBOUNCE_MAILSWEEP2,[l=1]# => q#(?aa)(?i)\bblocked by Mailsweeper\b#,
  q#__VBOUNCE_QUOTED_EXE,[l=1]# => q#(?aa)> TVqQAAMAAAAEAAAA#,
  q#__VBOUNCE_REJ_FILT,[l=1]# => q#(?aa)Reason: Rejected by filter#,
  q#__VBOUNCE_SECURIQ,[l=1]# => q#(?aa)\bGROUP securiQ.Wall\b#,
  q#__VBOUNCE_SMTP,[l=1]# => q#(?aa)host \S+ said: 5\d\d\s+Error: Message content rejected#,
  q#__VBOUNCE_STRIP_ATTACH,[l=1]# => q#(?aa)\bhas stripped one or more attachments from the following message\b#,
  q#__VBOUNCE_VALERT,[l=1]# => q#(?aa)The mail message \S+ \S+ you sent to \S+ contains the virus#,
  q#__WEBMAIL_ACCT,[l=1]# => q#(?aa)(?i)\byour web ?mail account#,
  q#__WE_PAID,[l=1]# => q#(?aa)(?i)\bwe have (?:already )?(?:paid|sent|remitted|issued) \$?\d+(?:,\d+)* (?:thousand )?(?:dollars )?to our (?:users|subscribers|members|clients|affiliates|partners)\b#,
  q#__WIDOW,[l=1]# => q#(?aa)(?i)\b(?:widow(?:e[rd])'?s?|veuve)\b#,
  q#__WILL_LEGAL,[l=1]# => q#(?aa)(?i)\b(?:codicil|last\stestament|probate|executor|intestate|bequest|mandamus)\b#,
  q#__WIRE_XFR,[l=1]# => q#(?aa)(?i)\b(?:wire|telegraph(?:ic)?|bank)\s?transfer#,
  q#__WITHOUT_EFFORT,[l=1]# => q#(?aa)(?i)\bwith(?:out(?: a(?:ny)?| the)?| no)(?: great| special| extra)? effort\b#,
  q#__YOUR_BANK,[l=1]# => q#(?aa)(?i)\byour?\s(?:full\s)?bank(?:ing)?\sinformations?\b#,
  q#__YOUR_CONSIGNMENT,[l=1]# => q#(?aa)(?i)\b(?:received?|pa(?:y|id)|sen[dt]|h[oe]ld|delay(?:ed)?|impound(?:ed)?|released?|ship(?:ped)?)\syour(?:\s\w+)?\sconsignment\b#,
  q#__YOUR_FUND,[l=1]# => q#(?aa)(?i)\b(?:your|ihr)\s(?:unpaid\s|win+ing\s|ap+roved\s|foreign\s|overdue\s|outstanding\s|contract\s|inheritance\s|nicht\sausbezahlten\s){0,3}(?:fund|f\su\sn\sd|payment|geld)\b#,
  q#__YOUR_PERM,[l=1]# => q#(?aa)(?i)\byour\spermission\b#,
  q#__YOUR_PROFIT,[l=1]# => q#(?aa)(?i)\byour?\sprofit#,
  q#__YOU_ASSIST,[l=1]# => q#(?aa)(?i)\b(?:your\sas+istan(?:ce|t)|votre\s(?:as+istance|aide))\b#,
  q#__YOU_INHERIT,[l=1]# => q#(?aa)(?i)\byour\s[a-z\s]{0,30}inherit+ance\b#,
  q#__YOU_WON_01,[l=1]# => q#(?aa)(?i)\byou(?:r|'re|'ve|'ll|\shave|\sdid)?\s(?:e-?mail\s)?(?:\w+\s){0,2}(?:a\s)?w[io]n+(?:er|ing)?(?!\xe2\x80\x99t)(?![`'\x92]t)\b#,
  q#__YOU_WON_02,[l=1]# => q#(?aa)(?i)\bw[io]n\s(?:(?:for|by)\s)?your?\b#,
  q#__YOU_WON_04,[l=1]# => q#(?aa)(?i)\bqu[ei]\s?(?:vous (?:[\xc3][\xaa]|=C3=AA|[\xea]|e)tes\s?gagnant|en\scons(?:e|=E9|[\xe9]|[\xc3][\xa9])quence\sgagne)\b#,
  q#__YOU_WON_05,[l=1]# => q#(?aa)(?i)\bI won(?!\xe2\x80\x99t)(?![`'\x92]t)\b#,
  q#__freemail_safe_fwd,[l=1]# => q#(?aa)(?i)---\s?(?:(?:Forwarded|Original) message|Alkuper(?:\xe4|\xc3\xa4)inen viesti)#,
  q#__hk_win_0,[l=1]# => q#(?aa)(?i)\byour? e-?mail just w[oi]n#,
  q#__hk_win_2,[l=1]# => q#(?aa)(?i)\battn.{0,10}winner#,
  q#__hk_win_3,[l=1]# => q#(?aa)(?i)\bhappily aa?nnounce#,
  q#__hk_win_4,[l=1]# => q#(?aa)(?i)\bpleas(?:ure|ed) to inform#,
  q#__hk_win_5,[l=1]# => q#(?aa)(?i)\b(?:notice the|your) winning#,
  q#__hk_win_7,[l=1]# => q#(?aa)(?i)\bcongratulations? to your#,
  q#__hk_win_8,[l=1]# => q#(?aa)(?i)\bunexpected luck#,
  q#__hk_win_9,[l=1]# => q#(?aa)(?i)\blucky (?:nl )number#,
  q#__hk_win_a,[l=1]# => q#(?aa)(?i)\bwinning (?:e-?mail|numbers|information)#,
  q#__hk_win_b,[l=1]# => q#(?aa)(?i)\byour e-?mail (?:address )?(?:has )?w[io]n#,
  q#__hk_win_c,[l=1]# => q#(?aa)(?i)\bune adresse e-?mail sur internet#,
  q#__hk_win_d,[l=1]# => q#(?aa)(?i)\bcategory (?:\S{0,5} )?winner of our#,
  q#__hk_win_i,[l=1]# => q#(?aa)(?i)\bfunds? transfer#,
  q#__hk_win_j,[l=1]# => q#(?aa)(?i)\b(?:winning|ready for|sum) pay ?out#,
  q#__hk_win_l,[l=1]# => q#(?aa)(?i)\b(?:make|file) (?:for )?your claim#,
  q#__hk_win_m,[l=1]# => q#(?aa)(?i)\br.clamation de votre prix#,
  q#__hk_win_n,[l=1]# => q#(?aa)(?i)\bcollect your prize#,
  q#__hk_win_o,[l=1]# => q#(?aa)(?i)\bclarification and procedure#,

};

XSLoader::load 'Mail::SpamAssassin::CompiledRegexps::body_0', $VERSION;
}

1;
__END__

=head1 NAME

Mail::SpamAssassin::CompiledRegexps::body_0 - Efficient string matching for regexps found in bases_body_0.in

=head1 SYNOPSIS

  use Mail::SpamAssassin::CompiledRegexps::body_0;
  
  ...
  my $match = Mail::SpamAssassin::CompiledRegexps::body_0::scan($string);

=head1 DESCRIPTION

This module was created by SpamAssassin with the aid of re2xs, which uses re2c
to create an XS library capable of scanning through a bunch of regular
expressions as defined in F<bases_body_0.in>.

See C<sa-compile> for more details.

=cut
