import errno


class ClusterlogicsError(Exception):
    pass


class RestoreError(ClusterlogicsError):
    pass


class TokenFileNotFoundError(ClusterlogicsError, FileNotFoundError):
    def __init__(self, filename, msg=None):
        self.errno = errno.ENOENT
        self.strerror = msg or 'Token file not found'
        self.filename = filename


class TokenValidationError(ClusterlogicsError, ValueError):
    msg_empty = 'Fields must not be empty'
    msg_absent = 'Fields must exist'

    def __init__(self, empty=None, absent=None, msg=None):
        self.msg = msg or 'Token validation failed'
        self.empty = empty
        self.absent = absent

    def __str__(self):
        if self.empty:
            keys = ', '.join(self.empty)
            return '{} {}: {}'.format(self.msg, self.msg_empty, keys)
        elif self.absent:
            keys = ', '.join(self.absent)
            return '{} {}: {}'.format(self.msg, self.msg_absent, keys)

        return '{}!'.format(self.msg)


class APIRequestError(ClusterlogicsError, ValueError):
    def __init__(self, err):
        self.err = err

    def __str__(self):
        return 'Server responded with an error: {}'.format(self.err)
