from defence360agent.api.integration_conf import IntegrationConfig
from defence360agent.contracts.config import UIRole
from defence360agent.subsys.panels.generic.panel import get_admin_list


class PamAuth:
    DEFAULT_AUTH_SERVICE = "system-auth"

    def authenticate(self, username, password) -> bool:
        from pam import pam

        try:
            config = IntegrationConfig().to_dict()
            service = config["PAM"]["SERVICE_NAME"]
        except KeyError:
            service = self.DEFAULT_AUTH_SERVICE

        p = pam()
        return p.authenticate(username, password, service=service)

    async def get_user_type(self, username: str) -> UIRole:
        admins = await get_admin_list()
        return UIRole.ADMIN if username in admins else UIRole.CLIENT
