import functools
import inspect

from defence360agent.contracts.config import ANTIVIRUS_MODE


def skip(f):
    @functools.wraps(f)
    async def async_wrapper(*args, **kwargs):
        return None if ANTIVIRUS_MODE else await f(*args, **kwargs)

    @functools.wraps(f)
    def wrapper(*args, **kwargs):
        return None if ANTIVIRUS_MODE else f(*args, **kwargs)

    return async_wrapper if inspect.iscoroutinefunction(f) else wrapper


enabled, disabled = ANTIVIRUS_MODE, not ANTIVIRUS_MODE
