import defence360agent.files

# static file types
EULA = defence360agent.files.EULA
GEO = "geo"
IP_RECORD = "ip-record"
MODSEC = "modsec-rules"
OSSEC = "ossec"
SIGS = defence360agent.files.SIGS
WHITELISTS = "static-whitelist"
PHP_IMMUNITY = "php-immunity"
PHP_IMMUNITY_V2 = "php-immunity-v2"
PROACTIVE = "proactive"
PROACTIVE_CONFIG = "proactive-config"
AUDITD_CONF = "auditd-log-reader"
EMAIL_RULES_V1 = "email-rules-v1"

Index = defence360agent.files.Index
update = defence360agent.files.update
update_and_log_error = defence360agent.files.update_and_log_error

DEFAULT_HOOKS = defence360agent.files.hooks.DEFAULT_HOOKS


def configure() -> None:
    defence360agent.files.configure()
    add_type = defence360agent.files.Index.add_type
    add_type(IP_RECORD, "ip-record/v1", 0o770, 0o660, all_zip=True)
    add_type(OSSEC, "ossec/v1", 0o770, 0o660, all_zip=True)
    add_type(WHITELISTS, "whitelist/v2", 0o770, 0o660, all_zip=True)
    add_type(MODSEC, "modsec/v2", 0o770, 0o660, all_zip=True)
    add_type(GEO, "geo/v1", 0o770, 0o660, all_zip=True)
    add_type(
        PHP_IMMUNITY,
        "php-immunity/v1",
        0o700,
        0o600,
        all_zip=False,
        essential=False,
    )
    add_type(
        PHP_IMMUNITY_V2,
        "php-immunity/v2",
        0o700,
        0o600,
        all_zip=False,
        essential=False,
    )
    add_type(
        PROACTIVE,
        "proactive/rules",
        0o770,
        0o600,
        all_zip=False,
        essential=False,
    )
    add_type(
        PROACTIVE_CONFIG,
        "proactive-config/v1",
        0o770,
        0o600,
        essential=False,
    )
    add_type(
        AUDITD_CONF,
        "auditd-log-reader/v1",
        0o770,
        0o660,
        all_zip=True,
    )
    add_type(
        EMAIL_RULES_V1,
        "email-rules/v1",
        0o770,
        0o600,
        all_zip=True,
        essential=False,
    )
