import logging
import subprocess

from defence360agent.subsys.panels.cpanel import cPanel

logger = logging.getLogger(__name__)


# iContact events priority (this enables Icontact events triggering)
def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    if not cPanel.is_installed():
        return
    try:
        subprocess.run(
            [
                "whmapi1",
                "set_application_contact_event_importance",
                "app=Imunify",
                "event=IELimit",
                "importance=High",
            ]
        )
    except Exception as e:
        logger.warning("Failed to set imporance for IELimit: %s", str(e))


def rollback(migrator, database, fake=False, **kwargs):
    pass
